/**
 * \file daemon_log.h
 *
 * \brief Daemon functions and defines for logging
 *
 * \author Christoph Gellner (cgellner@de.adit-jv.com)
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 *
 ***********************************************************************/

#ifndef __SDC_DAEMON_LOG_H_
#define __SDC_DAEMON_LOG_H_

#include <stdarg.h>

/** Logging levels */
typedef enum {
    DAEMON_LOG_DEBUG,
    DAEMON_LOG_INFO,
    DAEMON_LOG_WARNING,
    DAEMON_LOG_IMPORTANT_INFO,
    DAEMON_LOG_CRITICAL,
    DAEMON_LOG_ERROR,
} daemon_log_level_t;

void daemon_log(daemon_log_level_t level, const char *fmt, ...);
void daemon_vlog(daemon_log_level_t level, const char *fmt, va_list args);

#endif
